﻿//////////////////////////////////////////////
// Font.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Enums/FontAntiAliasingQuality.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Font
	{
		public :

			// Constructor, destructor
			Font () noexcept ;
			virtual ~Font () ;

			// Getters
			nkMemory::StringView getName () const ;
			nkMemory::StringView getFaceName () const ;
			FONT_ANTI_ALIASING_QUALITY getAntiAliasingQuality () const ;
			unsigned int getSize () const ;
			bool getDefault () const ;
			bool getReadyForUse () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setFaceName (nkMemory::StringView value) ;
			void setAntiAliasingQuality (FONT_ANTI_ALIASING_QUALITY value) ;
			void setSize (unsigned int value) ;
			void setDefault (bool value) ;

			// Loading
			virtual void load () = 0 ;
			virtual void unload () = 0 ;
			void reload () ;

		public :

			// Statics
			static nkMemory::UniquePtr<Font> create (System* system = nullptr) ;

		protected :

			// Settings
			nkMemory::String _name ;
			nkMemory::String _faceName ;
			FONT_ANTI_ALIASING_QUALITY _antiAliasingQuality ;
			unsigned int _size ;

			bool _default ;
			bool _readyForUse ;
	} ;
}